package cn.com.duiba.developer.center.api.domain.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * 人工充值支付方式
 * author zhanghuifeng
 * date 2018-11-29-10:53
 */
public enum ManualRechargeTypeEnum {

    ALIPAY(1, "支付宝"),
    WECHAT(2, "微信"),
    BANK(3, "银行卡");

    private Integer code;

    private String desc;

    ManualRechargeTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(Integer code){
        if (Objects.isNull(code)){
            return "";
        }
        ManualRechargeTypeEnum payTypeEnum = getByCode(code);
        if (Objects.nonNull(payTypeEnum)){
            return payTypeEnum.getDesc();
        }
        return "";
    }

    public static ManualRechargeTypeEnum getByCode(Integer code){
        return Arrays.stream(ManualRechargeTypeEnum.values()).filter(a -> a.code.equals(code)).findFirst().orElse(null);
    }

    public static boolean isExist(Integer code){
        return Objects.nonNull(code) &&
                Arrays.stream(ManualRechargeTypeEnum.values()).anyMatch(a -> a.code.equals(code));
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
