/**
 * Project Name:developer-center-api File Name:ShowcaseRelationTypeEnum.java Package
 * Name:cn.com.duiba.developer.center.api.domain.enums Date:2016年10月14日下午2:52:57 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.developer.center.api.domain.enums;

import org.apache.commons.lang.StringUtils;

import com.google.common.base.Objects;

/**
 * 橱窗位配置内容类型 
 * 
 * Date: 2016年10月14日 下午2:52:57 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public enum ShowcaseRelationTypeEnum implements EnumInterface {

    /** 兑吧商品 */
    ITEM("item", null,PushSourceTypeEnum.ITEM.getCode(), "兑吧商品"),

    /** 开发者自有商品 */
    APP_ITEM("app_item", null,null, "自有商品"),
    
    /** 兑吧专题活动 */
    DUIBA_ACTIVITY("duibaActivity", 0,null,"专题活动"),
    
    /** 老版大转盘，管理后台已关闭上架入口，开发者端还会用到 */
    OLD_TURNTABLE("oldTurntable",1, null, "大转盘"),

    /** 幸运大转盘 */
    TURNTABLE("turntable", 4,null, "幸运大转盘"),

    /** 兑吧单品抽奖 */
    SINGLE_LOTTERY("duibaSingleLottery", 2, PushSourceTypeEnum.SINGLE_LOTTERY.getCode(),"单品抽奖"),
    
    /* ==============APP自有活动============== */
    /** 自有单品抽奖 */
    APP_SINGLE_LOTTERY("appSingleLottery", 3, null,"单品抽奖"),
    
    /** 手动开奖 */
    APP_MANUAL_LOTTERY("appManualLottery", 5,null, "手动开奖"),

    /* ==============活动工具============== */
    /** 活动工具-摇奖机 */
    TOOL_TIGER("tiger", 9,PushSourceTypeEnum.HD_TOOL.getCode(), "摇奖机"),

    /** 活动工具-刮刮乐 */
    TOOL_SCRATCH_CARD("scratchCard", 7,PushSourceTypeEnum.HD_TOOL.getCode(), "刮刮乐"),

    /** 活动工具-摇一摇 */
    TOOL_SHAKE("shake", 6,PushSourceTypeEnum.HD_TOOL.getCode(), "摇一摇"),

    /** 活动工具-大转盘 */
    TOOL_TURNTABLE("turntableNew", 8,PushSourceTypeEnum.HD_TOOL.getCode(), "大转盘"),

    /** 活动工具-翻牌子 */
    TOOL_FLOP("flop", 11,PushSourceTypeEnum.HD_TOOL.getCode(), "翻牌子"),

    /** 活动工具-砸彩蛋 */
    TOOL_SMASHG("smashg", 12,PushSourceTypeEnum.HD_TOOL.getCode(), "砸彩蛋"),

    /* ==============老游戏活动============== */
    /** 圣诞老人 */
    GAME_SANTA("santa", 20,null, "圣诞老人"),

    /** 数年终奖 */
    GAME_YEAR_AWARD("yearAward", 21,null,  "数年终奖"),

    /** 女神PK */
    GAME_GIRL("girl", 22,null,  "女神PK"),

    /** 人在囧途 */
    GAME_JIONG("jiong", 23,null,  "人在囧途"),

    /* ==============新游戏活动============== */
    /** 兑吧游戏 */
    NEW_GAME("ngame", 28,PushSourceTypeEnum.NEW_GAME.getCode(),  "游戏"),

    /** 答题 */
    QUESTION("question", 40,PushSourceTypeEnum.QUESTION_ANSWER.getCode(), "答题"),

    /** 测试题 */
    QUIZZ("quizz", 41,PushSourceTypeEnum.QUIZZ.getCode(), "测试题"),
    
    /** 答题   迁移后用这个 */
    QUESTION_NEW("question", 101,PushSourceTypeEnum.QUESTION_ANSWER.getCode(), "答题"),

    /** 兑吧竞猜 */
    GUESS("guess", 42,PushSourceTypeEnum.GUESS.getCode(), "竞猜"),
    
    /** 秒杀活动 */
    DUIBA_SECKILL("seckill", 31,PushSourceTypeEnum.DUIBA_SECKILL.getCode(), "秒杀活动"),
    
    /** 秒杀专题 */
    SECONDS_KILL_ACTIVITY("secondsKillActivity", 30,PushSourceTypeEnum.SECONDS_KILL_ACTIVITY.getCode(), "秒杀专题"),
    
    /** 积分游戏 */
    CREDIT_GAME("creditGame", 46,PushSourceTypeEnum.Credit_Game.getCode(), "积分游戏"),
    
    /** 小游戏 */
    LITTLE_GAME("littleGame", 47,null, "小游戏");

    /** 代码 */
    private String  code;

    /** 活动类型，对应operating_activity.type */
    private Integer operatingActivityType;
    
    /**活动大类 对应 PushSourceTypeEnum 类**/
    private String sourceType;
    
    /** 描述 */
    private String  desc;

    private ShowcaseRelationTypeEnum(String code, Integer operatingActivityType,String sourceType, String desc) {
        this.code = code;
        this.operatingActivityType = operatingActivityType;
        this.sourceType = sourceType;
        this.desc = desc;
    }

    /**
     * 根据主字段获取枚举类
     * @param code 枚举主字段
     * @return 枚举类
     */
    public static ShowcaseRelationTypeEnum getByCode(String code) {
        for (ShowcaseRelationTypeEnum enumVal : ShowcaseRelationTypeEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * 根据活动类型获取关联枚举类
     * @param operatingActivityType 活动状态
     * @return
     */
    public static ShowcaseRelationTypeEnum getByType(Integer operatingActivityType) {
        for (ShowcaseRelationTypeEnum enumVal : ShowcaseRelationTypeEnum.values()) {
            if (enumVal.getOperatingActivityType() != null
                && Objects.equal(operatingActivityType, enumVal.getOperatingActivityType())) {
                return enumVal;
            }
        }
        return null;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDesc() {
        return desc;
    }
    
    
    
    public String getSourceType() {
		return sourceType;
	}
	public Integer getOperatingActivityType() {
        return operatingActivityType;
    }
}
