package cn.com.duiba.developer.center.api.domain.enums.crm;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by 刘凯 on 2020/06/12.
 */
public enum ClueSubjectInfoEnum {

    UNKNOWN(1,"未定"),
    DUIBA(2,"兑吧"),
    DUIA(3,"兑啊"),
    DUIJIE(3,"兑捷"),



    ;


    private static final Map<Integer, ClueSubjectInfoEnum> enumMap = new HashMap<>();
    static{
        for(ClueSubjectInfoEnum clueSubjectInfoEnum : values()){
            enumMap.put(clueSubjectInfoEnum.getCode(), clueSubjectInfoEnum);
        }
    }

    public static ClueSubjectInfoEnum getByCode(Integer code){
        ClueSubjectInfoEnum clueSubjectInfoEnum = enumMap.get(code);
        if(clueSubjectInfoEnum == null){
            return null;
        }
        return clueSubjectInfoEnum;
    }

    private Integer code;
    private String desc;

    ClueSubjectInfoEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
