package cn.com.duiba.developer.center.api.domain.enums.crm;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by 刘凯 on 2020/06/12.
 */
public enum ClueVitalityEnum {

    HIGH_ACTIVITY(1,"高活跃度"),
    MID_ACTIVITY(2,"中活跃度"),
    LOW_ACTIVITY(3,"低活跃度"),
    WARN_LOSE(4,"预警流失"),
    SLEEP(5,"沉睡"),



    ;

    private static final Map<Integer, ClueVitalityEnum> enumMap = new HashMap<>();
    static{
        for(ClueVitalityEnum clueVitalityEnum : values()){
            enumMap.put(clueVitalityEnum.getCode(), clueVitalityEnum);
        }
    }

    public static ClueVitalityEnum getByCode(Integer code){
        ClueVitalityEnum clueVitalityEnum = enumMap.get(code);
        if(clueVitalityEnum == null){
            return null;
        }
        return clueVitalityEnum;
    }

    private Integer code;
    private String desc;

    ClueVitalityEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
