package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Administrator on 2018/4/26.
 */
public enum PaymentMethodEnum {
    /**
     * 支付方式
     * paymentMethod
     */
    UNDER_LINE(1,"线下"),
    ALIPAY(2,"支付宝"),
    ACCOUNT_BALANCE(3,"账户余额"),
    VERSION_GIFT(4,"版本内授权");

    private static final Map<Integer, PaymentMethodEnum> ENUM_MAP = new HashMap<>();
    static{
        for(PaymentMethodEnum paymentMethodEnum : values()){
            ENUM_MAP.put(paymentMethodEnum.getValue(), paymentMethodEnum);
        }
    }

    public static PaymentMethodEnum getByCode(Integer code){
        PaymentMethodEnum paymentMethodEnum = ENUM_MAP.get(code);
        if(paymentMethodEnum == null){
            throw new DeveloperCenterException("不支持的支付类型");
        }
        return paymentMethodEnum;
    }

    private int    value;
    private String desc;

    PaymentMethodEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
