package cn.com.duiba.developer.center.api.domain.enums.visualeditor;

/**
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @date 2018/8/9 0009 14:57
 */

import cn.com.duiba.developer.center.api.domain.dto.visualeditor.VisualEditorUnitGroupDto;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 组件类型枚举
 * 1.可视化编辑器使用
 *
 * @author Administrator
 */
public enum UnitsGroupEnum {
    SINGLE_COLUMN(1, "单列图组件", "图文类"),
    DOUBLE_COLUMN(2, "双列图组件", "图文类"),
    SLIDE_SHOW(3, "轮播图组件", "图文类"),
    HORIZONTAL_SLIDING(4, "横向滑动组件", "图文类"),
    GRAPHIC_NAVIGATION(5, "图文导航组件", "图文类"),
    TITLE(6, "标题组件", "图文类"),
    TEXT(7, "文本组件", "图文类"),
    GOODS(8, "商品组件", "商品类"),
    GOODS_GROUPS(9, "商品分组组件", "商品类"),
    ACTIVITY(10, "活动组件", "营销类"),
    ACTIVITY_GROUPS(11, "活动分组组件", "营销类"),
    POINTS(12, "积分组件", "营销类"),
    PAGE_SIGN_IN(13, "页面签到组件", "营销类"),
    POPUP_SIGN_IN(14, "弹窗签到组件", "营销类"),
    GUIDES_LINE(15, "辅助线组件", "图文类"),
    SHOW_WINDOW(16, "橱窗位组件", "图文类"),
    SELF_DEFINING(17, "自定义组件", "其他类"),
    NOTICE(18,"公告组件","页面预设"),
    FLOATING_LAYER(19,"浮层组件","图文类"),
    POPUP(20,"弹窗组件","图文类"),
    BUOY(21,"浮标组件","图文类"),
    DAY_SECKILL(22,"天天秒杀组件","其他类"),
    SEC_KILL(23, "秒杀组件", "营销类"),
    COMM_TEMPLATE(24, "通用组件", "其他类"),
    ;






    private Integer code;
    private String desc;
    private String groupName;

    private static List<VisualEditorUnitGroupDto> list = null;

    static {
        list = new ArrayList<>(UnitsGroupEnum.values().length);
        for (UnitsGroupEnum each : UnitsGroupEnum.values()) {
            list.add(new VisualEditorUnitGroupDto(each.getCode(), each.getDesc()));
        }
    }

    UnitsGroupEnum(Integer code, String desc, String groupName) {
        this.code = code;
        this.desc = desc;
        this.groupName = groupName;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getGroupName() {
        return groupName;
    }

    public static List<VisualEditorUnitGroupDto> getList() {
        return list;
    }

    /**
     * 根据code返回enum
     *
     * @param code
     * @return
     */
    public static UnitsGroupEnum ofCode(int code) {

        for (UnitsGroupEnum each : UnitsGroupEnum.values()) {
            if (Objects.equals(each.getCode(), code)) {
                return each;
            }
        }
        throw new UnsupportedOperationException("no such UnitsGroupEnum ");
    }







}
