package cn.com.duiba.developer.center.api.domain.paramquery;

import cn.com.duiba.developer.center.api.domain.dto.saas.SaasGrantDto;
import cn.com.duiba.developer.center.api.domain.enums.saas.SaasFuncTypeEnum;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * Created by xiaoxuda on 2018/4/12.
 */
public class SaasGrantQueryParam implements Serializable{
    private static final long serialVersionUID = -5997411168682212705L;

    /**
     * appID
     **/
    @NotNull
    private Long appId;
    /**
     * 功能类型：1，积分商城；2.签到；3：活动；4：皮肤；
     **/
    @NotNull
    private SaasFuncTypeEnum funcType;
    /**
     * 功能子类型（活动类型，商城皮肤、签到皮肤、活动皮肤）
     **/
    private Integer funcSubType = SaasGrantDto.DEFAULT_FUNC_SUB_TYPE;
    /**
     * 关联ID（活动、签到）
     **/
    private Long funcRelId = SaasGrantDto.DEFAULT_FUNC_REL_ID;

    public SaasGrantQueryParam(Long appId, SaasFuncTypeEnum funcType, Integer funcSubType, Long funcRelId){
        this.appId = appId;
        this.funcType = funcType;
        this.funcSubType = funcSubType;
        this.funcRelId = funcRelId;
    }

    public SaasGrantQueryParam(){
        //默认构造函数
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public SaasFuncTypeEnum getFuncType() {
        return funcType;
    }

    public void setFuncType(SaasFuncTypeEnum funcType) {
        this.funcType = funcType;
    }

    public Integer getFuncSubType() {
        return funcSubType;
    }

    public void setFuncSubType(Integer funcSubType) {
        this.funcSubType = funcSubType;
    }

    public Long getFuncRelId() {
        return funcRelId;
    }

    public void setFuncRelId(Long funcRelId) {
        this.funcRelId = funcRelId;
    }
}
