package cn.com.duiba.developer.center.api.domain.paramquery.strategy;

import cn.com.duiba.developer.center.api.domain.constant.StrategyExperienceStatusEnum;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryParam;

import java.util.Date;
import java.util.List;


public class ExperienceQueryParam extends PageQueryParam {
    private Long id;
    /**
     * ID
     */
    private List<Long> ids;
    /**
     * 类型
     */
    private Long typeId;
    private List<Long> typeIdList;


    /**
     * 经验来源ID
     */
    private Long sourceId;
    private List<Long> sourceIdList;

    /**
     * 经验描述(模糊查询)
     */
    private String fuzzyDescription;
    /**
     * 标签(模糊查询)
     */
    private List<Long> tagIds;

    /**
     * 创建者姓名
     */
    private String creator;

    /**
     * 状态 0:待审核 1:审核通过 2:审核拒绝
     * {@link StrategyExperienceStatusEnum}
     */
    private Integer auditStatus;
    private List<Integer> auditStatusList;

    /**
     * 删除状态 0:未删除 1:删除
     */
    private Integer deleted = 0;

    /**
     * 创建时间
     */
    private Date gmtCreateSt;
    private Date gmtCreateEd;


    private Integer total;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public Long getTypeId() {
        return typeId;
    }

    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }

    public List<Long> getTypeIdList() {
        return typeIdList;
    }

    public void setTypeIdList(List<Long> typeIdList) {
        this.typeIdList = typeIdList;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public List<Long> getSourceIdList() {
        return sourceIdList;
    }

    public void setSourceIdList(List<Long> sourceIdList) {
        this.sourceIdList = sourceIdList;
    }

    public String getFuzzyDescription() {
        return fuzzyDescription;
    }

    public void setFuzzyDescription(String fuzzyDescription) {
        this.fuzzyDescription = fuzzyDescription;
    }

    public List<Long> getTagIds() {
        return tagIds;
    }

    public void setTagIds(List<Long> tagIds) {
        this.tagIds = tagIds;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public List<Integer> getAuditStatusList() {
        return auditStatusList;
    }

    public void setAuditStatusList(List<Integer> auditStatusList) {
        this.auditStatusList = auditStatusList;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreateSt() {
        return gmtCreateSt;
    }

    public void setGmtCreateSt(Date gmtCreateSt) {
        this.gmtCreateSt = gmtCreateSt;
    }

    public Date getGmtCreateEd() {
        return gmtCreateEd;
    }

    public void setGmtCreateEd(Date gmtCreateEd) {
        this.gmtCreateEd = gmtCreateEd;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }
}
