package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * App日交易数记录服务
 */
@AdvancedFeignClient
public interface RemoteAppTradingLimitService {
    /**
     * App下交易次数加1
     * @param appId
     * @return
     */
    DubboResult<Boolean> addTrading(Long appId);

    /**
     * 获取今天App下的交易次数
     * @param appId
     * @return
     */
    DubboResult<Integer> getTodayTradingCount(Long appId);

}
