package cn.com.duiba.developer.center.api.utils;

import java.io.File;
import java.util.List;

import cn.com.duiba.developer.center.api.DeveloperCenterException;
import org.apache.commons.lang.StringUtils;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.io.CharSink;
import com.google.common.io.Files;

/**
 * Created by liuyao on 2017/2/9.
 */
public class DBcongfigFileContext {

    private Splitter spl = Splitter.on("\n").omitEmptyStrings();
    private Joiner joiner = Joiner.on("\n").skipNulls();

    private static final String CONTEXT_KEY = "duiba:config";
    private static final String END = "</"+CONTEXT_KEY+">";

    private Multimap<String,String> LINE_MAP = LinkedListMultimap.create();

    private String curreryId;

    protected void addLine(String line){
        if(StringUtils.isBlank(line)){
            return;
        }
        if(line.contains("duiba:config id")){
            if(StringUtils.isNotBlank(curreryId)){
                throw new DeveloperCenterException("duibaconfig文件非闭合");
            }
            curreryId = getId(line);
            return;
        }
        if(line.contains(END)){
            if(StringUtils.isBlank(curreryId)){
                throw new DeveloperCenterException("duibaconfig文件非闭合");
            }
            curreryId = null;
            return;
        }
        LINE_MAP.put(curreryId,line);
    }

    private List<String> toStringList(){
        List<String> lines = Lists.newArrayList();
        for(String id:LINE_MAP.keySet()){
            lines.add(getConfigPre(id));
            lines.addAll(LINE_MAP.get(id));
            lines.add(END);
        }
        return lines;
    }

    public int put(String id,String code){
        if(StringUtils.isBlank(id)){
            throw new DeveloperCenterException("duibaconfig文件键值不能为空");
        }
        if(StringUtils.isBlank(code)){
            return 0;
        }
        if(code.contains(CONTEXT_KEY)){
            throw new DeveloperCenterException("duibaconfig文件的内容不能包含关键字符");
        }
        if(LINE_MAP.containsKey(id)){
            LINE_MAP.removeAll(id);
        }
        List<String> lines = spl.splitToList(code);
        LINE_MAP.putAll(id,lines);
        return lines.size();
    }

    public int remove(String id){
        if(!LINE_MAP.containsKey(id)){
            return 0;
        }
        int count = LINE_MAP.get(id).size();
        LINE_MAP.removeAll(id);
        return count;
    }

    public String get(String id){
        if(!LINE_MAP.containsKey(id)){
            return "";
        }
        return joiner.join(LINE_MAP.get(id));
    }

    public boolean contains(String key){
        return LINE_MAP.containsKey(key);
    }


    public void toFile(File file) {
        try {
            CharSink sink = Files.asCharSink(file, Charsets.UTF_8);
            List<String> lines = this.toStringList();
            sink.writeLines(lines);
        } catch (Exception e) {
            throw new DeveloperCenterException("duibaconfig文件内容转储失败", e);
        }
    }

    public String md5(){
        List<String> lines = toStringList();
        return MD5.md5(joiner.join(lines));
    }

    private String getConfigPre(String id){
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(CONTEXT_KEY).append(" ").append("id=\"").append(id).append("\">");
        return sb.toString();
    }

    private String getId(String line){
        int bigin = line.indexOf('\"');
        int end = line.lastIndexOf('\"');
        return line.substring(bigin+1,end);
    }
}
