package cn.com.duiba.developer.center.api.domain.enums.risk;

import java.util.Objects;

/**
 * @author JunAngLiu
 * @Title: RiskWhiteListSenceEnum
 * @Description:
 * @date 2019/6/1820:59
 */
public enum RiskWhiteListSenceEnum {

    WITH_DRAW(1,"提现"),
    PARTICIPATION(2,"参与"),
    PRIZE(3,"发奖"),
    EXCHANGE(4,"兑换"),
    ASSIST(7,"助力");

    private Integer value;
    private String desc;

    public Integer getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    RiskWhiteListSenceEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static RiskWhiteListSenceEnum getEnumByValue(Integer value){
        if(Objects.isNull(value)){
            return null;
        }
        for (RiskWhiteListSenceEnum rse:RiskWhiteListSenceEnum.values()) {
            if(Objects.equals(rse.getValue(),value)){
                return rse;
            }
        }
        return null;
    }
}
