package cn.com.duiba.developer.center.api.remoteservice.crm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.crm.LccAppWeekActiveScoreDto;
import cn.com.duiba.developer.center.api.domain.dto.crm.RzyAppActiveScoreDto;

import java.util.Date;

/**
 * 活跃度查询
 *
 * @author haojiahong
 * @date 2020-06-18
 */
@AdvancedFeignClient
public interface RemoteClueAppActiveScoreService {

    /**
     * 周活跃度查询
     *
     * @param weekLastDay 自然周最后一天
     * @param appId       appId
     * @return
     */
    LccAppWeekActiveScoreDto queryWeek(Date weekLastDay, Long appId);

    /**
     * 月活跃度查询
     *
     * @param month 月份，格式：yyyy-MM
     * @param appId appId
     * @return
     */
    RzyAppActiveScoreDto queryMonth(String month, Long appId);
}
