package cn.com.duiba.developer.center.api.remoteservice.crm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.crm.ClueAppNewsInfoDto;
import cn.com.duiba.developer.center.api.domain.param.crm.ClueAppNewsQueryParam;

import java.util.List;

/**
 * @author 刘凯
 * @date 2020-06-12
 */
@AdvancedFeignClient
public interface RemoteClueNewsInfoService {

    List<ClueAppNewsInfoDto> getByClueAppId(List<Long> clueAppIds);

    /**
     * 【动态】通过clueAppId查询动态列表
     *
     * @param clueAppId
     * @return
     */
    List<ClueAppNewsInfoDto> getNewsListByClueAppId(Long clueAppId);

    /**
     * 【动态】通过条件查询动态列表
     *
     * @param param
     * @return
     */
    List<ClueAppNewsInfoDto> getNewsListByParam(ClueAppNewsQueryParam param);

    /**
     * 【动态】添加动态
     *
     * @param pojo
     * @return
     */
    Boolean saveNews(ClueAppNewsInfoDto pojo);

}
