/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.domain.enums.survey;

import java.util.Objects;
import java.util.Optional;

public enum QuestionTypeEnum {
    FEEDBACK("feedback", "\u53cd\u9988", 0),
    RADIO("radio", "\u5355\u9009", 2),
    TEXT("text", "\u5355\u884c", 0),
    TEXT_AREA("textarea", "\u591a\u884c\u6587\u672c", 0),
    CHECKBOX("checkbox", "\u591a\u9009", 2);

    private final String type;
    private final String msg;
    private final int requireOptionSize;

    private QuestionTypeEnum(String type, String msg, int requireOptionSize) {
        this.type = type;
        this.msg = msg;
        this.requireOptionSize = requireOptionSize;
    }

    public String getType() {
        return this.type;
    }

    public String getMsg() {
        return this.msg;
    }

    public int getRequireOptionSize() {
        return this.requireOptionSize;
    }

    public static Optional<QuestionTypeEnum> getQuestionTypeEnumByType(String type) {
        for (QuestionTypeEnum value : QuestionTypeEnum.values()) {
            if (!Objects.equals(value.getType(), type)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public String toString() {
        return this.type;
    }
}

