package cn.com.duiba.developer.center.api.domain.dto.crm;

import java.io.Serializable;
import java.util.Date;

/**
* 客户续费信息表
*/
public class ClueAppRenewInfoDto implements Serializable {

    private static final long serialVersionUID = -4068795747978678770L;
    /**
    * 
    */
    private Long id;

    /**
    * 客户应用关联id
    */
    private Long clueAppId;

    /**
    * 续费意向类型，1：意向续费，2：确认续费，3：已续费，4：续费预警，5：确认不续费
    */
    private Integer intentType;

    /**
    * 不续费原因类型，1：平台下线，2：失联，3：价格异议，4：竞品对接，5：自行开发，6：不重视积分运营，7：其他
    */
    private Integer noIntentType;

    /**
    * 不续费原因是其他时的附加信息
    */
    private String noIntentExtraMsg;

    /**
    * 不续费详细描述
    */
    private String noIntentDetailMsg;

    /**
    * 到款时间
    */
    private Date arrivalDate;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setClueAppId(Long clueAppId) {
        this.clueAppId = clueAppId;
    }

    public Long getClueAppId() {
        return clueAppId;
    }

    public void setIntentType(Integer intentType) {
        this.intentType = intentType;
    }

    public Integer getIntentType() {
        return intentType;
    }

    public void setNoIntentType(Integer noIntentType) {
        this.noIntentType = noIntentType;
    }

    public Integer getNoIntentType() {
        return noIntentType;
    }

    public void setNoIntentExtraMsg(String noIntentExtraMsg) {
        this.noIntentExtraMsg = noIntentExtraMsg;
    }

    public String getNoIntentExtraMsg() {
        return noIntentExtraMsg;
    }

    public void setNoIntentDetailMsg(String noIntentDetailMsg) {
        this.noIntentDetailMsg = noIntentDetailMsg;
    }

    public String getNoIntentDetailMsg() {
        return noIntentDetailMsg;
    }

    public void setArrivalDate(Date arrivalDate) {
        this.arrivalDate = arrivalDate;
    }

    public Date getArrivalDate() {
        return arrivalDate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

}

