package cn.com.duiba.developer.center.api.domain.dto.survey;

import cn.com.duiba.developer.center.api.domain.enums.survey.ChannelTypeEnum;
import cn.com.duiba.developer.center.api.domain.enums.survey.LabelEnum;
import cn.com.duiba.developer.center.api.domain.enums.survey.SurveyStatusEnum;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class SurveyDto implements Serializable {
    private static final long serialVersionUID = -965896914235968154L;
    /**
     * ID
     */
    private Long id;
    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 类型 0-模板 1-问券
     */
    private Integer type;
    /**
     * appId
     */
    @Min(value = 0, message = "appId不合法")
    private Long appId;

    /**
     * 客户名称
     */
    @Size(max = 50, message = "appName过长")
    private String appName;
    /**
     * 渠道类型/场景类型
     * {@link ChannelTypeEnum}
     */
    @NotNull
    @Min(value = 1, message = "channelType不合法")
    @Max(value = 3, message = "channelType不合法")
    private Integer channelType;
    /**
     * 活动Id
     */
    @Min(value = 0, message = "activityId不合法")
    private Long activityId;

    /**
     * 活动名称
     */
    @Size(max = 20, message = "activityName过长")
    private String activityName;

    /**
     * 最新版本
     * 从1开始
     */
    private Integer version;
    /**
     * 标题C端名称
     */
    @Size(max = 20, message = "title过长")
    @NotNull(message = "title必填")
    private String title;

    /**
     * 问候语
     */
    @Size(max = 50, message = "问候语过长")
    @NotNull(message = "问候语必填")
    private String prefix;
    /**
     * B端名称
     */
    @Size(max = 20, message = "name过长")
    @NotNull(message = "name必填")
    private String name;

    /**
     * 标签
     * {@link LabelEnum}
     */
    @NotNull(message = "label必填")
    @Size(max = 20, message = "label过长")
    private String label;

    /**
     * 来源Id,复制
     */
    @Min(value = 0, message = "sourceId不合法")
    private Long sourceId;
    /**
     * 状态
     * {@link SurveyStatusEnum}
     */
    private Integer status;


    @Size(min = 1, max = 100, message = "最多只可添加 100 个问题")
    private List<QuestionDto> questions;

    /**
     * 填写人数
     */
    private Integer joinCount = 0;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Integer getChannelType() {
        return channelType;
    }

    public void setChannelType(Integer channelType) {
        this.channelType = channelType;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPrefix() {
        return prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public List<QuestionDto> getQuestions() {
        return questions;
    }

    public void setQuestions(List<QuestionDto> questions) {
        this.questions = questions;
    }

    public Integer getJoinCount() {
        return joinCount;
    }

    public void setJoinCount(Integer joinCount) {
        this.joinCount = joinCount;
    }


}
