package cn.com.duiba.developer.center.api.domain.enums.survey;

import java.util.Objects;
import java.util.Optional;

/**
 * 问题类型
 */
public enum QuestionTypeEnum {
    FEEDBACK("feedback", "反馈", false),
    RADIO("radio", "单选", true),
    TEXT("text", "单行", false),
    TEXT_AREA("textarea", "多行文本", false),
    CHECKBOX("checkbox", "多选", true),
    ;

    private final String type;
    private final String msg;
    /**
     * 是否必须有option
     */
    private final boolean requireOption;

    QuestionTypeEnum(String type, String msg, boolean requireOption) {
        this.type = type;
        this.msg = msg;
        this.requireOption = requireOption;
    }

    public String getType() {
        return type;
    }

    public String getMsg() {
        return msg;
    }

    public boolean isRequireOption() {
        return requireOption;
    }

    public static Optional<QuestionTypeEnum> getQuestionTypeEnumByType(String type) {
        for (QuestionTypeEnum value : QuestionTypeEnum.values()) {
            if (Objects.equals(value.getType(), type)) {
                return Optional.of(value);
            }
        }
        return Optional.empty();
    }


    @Override
    public String toString() {
        return type;
    }
}
