package cn.com.duiba.developer.center.api.domain.param.crm;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class ClueSelectParam implements Serializable {


    private static final long serialVersionUID = 8957651516440954148L;
    // ===============        客户线索表           ========
    /**
     * 客户简称
     */
    private String shortName;
    /**
     * 公司名称
     */
    private String companyName;
    /**
     * 是否拜访  1 未拜访  2  拜访
     */
    private Integer hasVisit;
    /**
     * 合作目的 1. 未知 2 积分消耗 3 用户留存 4 会员活跃 5 用户拉新 6 采购 7 其他
     */
    private Integer purpose;
    /**
     * 合作方式 1  积分商城 2 定制活动
     */
    private Integer purposeType;
    /**
     * 合作状态 1. 未合作 2 合作中 3 合作终止
     */
    private Integer purposeStatus;
    /**
     * 一级行业
     */
    private String headIndustry;
    /**
     * 二级行业
     */
    private String secondIndustry;

    /**
     * 客户分组  1：全行业，2：银行，3：政企，4：淘宝，5：保险
     */
    private Integer groupType;
    /**
     * 客户分层 1：未定，2：中长尾，3：KA，4：GSKA
     */
    private Integer layerType;
    /**
     * 拜访时间
     */
    private List<Date> visitDate;





    // ===============        客户线索应用表           ========

    /**
     * 应用阶段 应用阶段  1  待激活  2  上线中 3 续费期 4 流失
     */
    private Integer applyStage;

    /**
     * 应用名称
     */
    private String appName;
    /**
     * appid
     */
    private Long appId;

    /**
     * 活跃度   1 高活跃度 2 中活跃度 3 低活跃度 4 预警流失 5 沉睡
     */
    private Integer vitality;



    // ===============        客户续费表           ========
    /**
     * 续费意向 1 意向续费 2 确认续费 3 已续费 4 续费预警5 确认不续费
     */
    private Integer intentType;
    /**
     * 不续费原因 1. 平台下线 2 失联 3 价格异议 4 竞品对接 5 自行开发 6 不重视积分运营 6 其他
     */
    private Integer noIntentType;
    // ===============        客户订购表           ========
    /**
     * 版本
     */
    private String versionName;

    /**
     *实际金额
     */
    private List<Long> actualMoney;

    /**
     * 1. 订购日期 2 到期日期
     */
    private Integer selectDateType;
    /**
     * 开始时间
     */
    private Date startDate;
    /**
     * 结束时间
     */
    private Date endDate;

    // ===============        客户分配关系表          ========
    /**
     * 对接人名称
     */
    private String takerName;
    /**
     * 商务
     */
    private List<Long> businessUserIds;
    /**
     * 售前
     */
    private List<Long> saleBeforeUserIds;
    /**
     * 售后
     */
    private List<Long> saleAfterUserIds;
    /**
     * 技术支持
     */
    private List<Long> technologySupportUserIds;

    /**
     * 1. 自己客户，2 所有客户
     */
    private Long createUser;

    private Integer pageNo;

    private Integer pageSize;


    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getApplyStage() {
        return applyStage;
    }

    public void setApplyStage(Integer applyStage) {
        this.applyStage = applyStage;
    }

    public Integer getPurpose() {
        return purpose;
    }

    public void setPurpose(Integer purpose) {
        this.purpose = purpose;
    }

    public Integer getPurposeType() {
        return purposeType;
    }

    public void setPurposeType(Integer purposeType) {
        this.purposeType = purposeType;
    }

    public Integer getIntentType() {
        return intentType;
    }

    public void setIntentType(Integer intentType) {
        this.intentType = intentType;
    }

    public Integer getVitality() {
        return vitality;
    }

    public void setVitality(Integer vitality) {
        this.vitality = vitality;
    }

    public String getVersionName() {
        return versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public Integer getGroupType() {
        return groupType;
    }

    public void setGroupType(Integer groupType) {
        this.groupType = groupType;
    }

    public Integer getLayerType() {
        return layerType;
    }

    public void setLayerType(Integer layerType) {
        this.layerType = layerType;
    }

    public List<Long> getActualMoney() {
        return actualMoney;
    }

    public void setActualMoney(List<Long> actualMoney) {
        this.actualMoney = actualMoney;
    }

    public List<Date> getVisitDate() {
        return visitDate;
    }

    public void setVisitDate(List<Date> visitDate) {
        this.visitDate = visitDate;
    }

    public String getHeadIndustry() {
        return headIndustry;
    }

    public void setHeadIndustry(String headIndustry) {
        this.headIndustry = headIndustry;
    }

    public String getSecondIndustry() {
        return secondIndustry;
    }

    public void setSecondIndustry(String secondIndustry) {
        this.secondIndustry = secondIndustry;
    }

    public String getTakerName() {
        return takerName;
    }

    public void setTakerName(String takerName) {
        this.takerName = takerName;
    }

    public Integer getSelectDateType() {
        return selectDateType;
    }

    public void setSelectDateType(Integer selectDateType) {
        this.selectDateType = selectDateType;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getPurposeStatus() {
        return purposeStatus;
    }

    public void setPurposeStatus(Integer purposeStatus) {
        this.purposeStatus = purposeStatus;
    }

    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public List<Long> getBusinessUserIds() {
        return businessUserIds;
    }

    public void setBusinessUserIds(List<Long> businessUserIds) {
        this.businessUserIds = businessUserIds;
    }

    public List<Long> getSaleBeforeUserIds() {
        return saleBeforeUserIds;
    }

    public void setSaleBeforeUserIds(List<Long> saleBeforeUserIds) {
        this.saleBeforeUserIds = saleBeforeUserIds;
    }

    public List<Long> getSaleAfterUserIds() {
        return saleAfterUserIds;
    }

    public void setSaleAfterUserIds(List<Long> saleAfterUserIds) {
        this.saleAfterUserIds = saleAfterUserIds;
    }

    public List<Long> getTechnologySupportUserIds() {
        return technologySupportUserIds;
    }

    public void setTechnologySupportUserIds(List<Long> technologySupportUserIds) {
        this.technologySupportUserIds = technologySupportUserIds;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Integer getHasVisit() {
        return hasVisit;
    }

    public void setHasVisit(Integer hasVisit) {
        this.hasVisit = hasVisit;
    }

    public Integer getNoIntentType() {
        return noIntentType;
    }

    public void setNoIntentType(Integer noIntentType) {
        this.noIntentType = noIntentType;
    }
}
