/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.utils;

import cn.com.duiba.developer.center.api.domain.dto.survey.OptionDto;
import cn.com.duiba.developer.center.api.domain.dto.survey.QuestionDto;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionDiffTool {
    private static final Logger LOG = LoggerFactory.getLogger(QuestionDiffTool.class);

    public static boolean diff(List<QuestionDto> beforeQuestions, List<QuestionDto> afterQuestions) {
        if (QuestionDiffTool.diff(beforeQuestions.size(), afterQuestions.size(), "\u95ee\u9898\u6570\u91cf")) {
            return true;
        }
        for (int i = 0; i < beforeQuestions.size(); ++i) {
            if (!QuestionDiffTool.diffQuestion(beforeQuestions.get(i), afterQuestions.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean diff(Object before, Object after, String desc) {
        if (!Objects.equals(before, after)) {
            LOG.info("\u95ee\u9898\u66f4\u65b0\uff1a{},before={},after={}", new Object[]{desc, before, after});
            return true;
        }
        return false;
    }

    private static boolean diffQuestion(QuestionDto before, QuestionDto after) {
        if (QuestionDiffTool.diffCode(before.getCode(), after.getCode())) {
            return true;
        }
        if (QuestionDiffTool.diff(before.getType(), after.getType(), "\u95ee\u9898\u7c7b\u578b")) {
            return true;
        }
        if (after.getTitle() != null && QuestionDiffTool.diff(before.getTitle(), after.getTitle(), "\u95ee\u9898\u6807\u9898")) {
            return true;
        }
        if (after.getDescription() != null && QuestionDiffTool.diff(before.getDescription(), after.getDescription(), "\u95ee\u9898\u63cf\u8ff0")) {
            return true;
        }
        if (QuestionDiffTool.diff(before.getRequired(), after.getRequired(), "\u95ee\u9898\u5fc5\u586b\u5c5e\u6027")) {
            return true;
        }
        if (after.getValidate() != null && QuestionDiffTool.diff(before.getValidate(), after.getValidate(), "\u95ee\u9898\u6821\u9a8c")) {
            return true;
        }
        if (after.getDisplay() != null && QuestionDiffTool.diff(before.getDisplay(), after.getDisplay(), "\u95ee\u9898\u5c55\u793a\u903b\u8f91")) {
            return true;
        }
        if (after.getJump() != null && QuestionDiffTool.diff(before.getJump(), after.getJump(), "\u95ee\u9898\u8df3\u8f6c\u903b\u8f91")) {
            return true;
        }
        return before.getOptions() != null && QuestionDiffTool.diffOptions(before.getOptions(), after.getOptions());
    }

    private static boolean diffOptions(List<OptionDto> beforeOptions, List<OptionDto> afterOptions) {
        if (QuestionDiffTool.diff(beforeOptions, afterOptions, "\u9009\u9879\u5b58\u5728")) {
            return true;
        }
        if (QuestionDiffTool.diff(beforeOptions.size(), afterOptions.size(), "\u9009\u9879\u6570\u91cf")) {
            return true;
        }
        for (int i = 0; i < beforeOptions.size(); ++i) {
            if (!QuestionDiffTool.diffOption(beforeOptions.get(i), afterOptions.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean diffOption(OptionDto before, OptionDto after) {
        if (QuestionDiffTool.diffCode(before.getCode(), after.getCode())) {
            return true;
        }
        if (QuestionDiffTool.diff(before.getTitle(), after.getTitle(), "\u9009\u9879\u9898\u76ee")) {
            return true;
        }
        if (QuestionDiffTool.diff(before.getType(), after.getType(), "\u9009\u9879\u7c7b\u578b")) {
            return true;
        }
        if (after.getDisplay() != null && QuestionDiffTool.diff(before.getDisplay(), after.getDisplay(), "\u9009\u9879\u5c55\u793a\u903b\u8f91")) {
            return true;
        }
        if (after.getJump() != null && QuestionDiffTool.diff(before.getJump(), after.getJump(), "\u9009\u9879\u8df3\u8f6c\u903b\u8f91")) {
            return true;
        }
        return QuestionDiffTool.diff(before.getExclusive(), after.getExclusive(), "\u9009\u9879\u4e92\u65a5");
    }

    private static boolean diffCode(String before, String after) {
        String[] split = before.split("-");
        String[] split1 = after.split("-");
        for (int i = 0; i < 2; ++i) {
            if (!QuestionDiffTool.diff(split[i], split1[i], "\u7f16\u7801")) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println(QuestionDiffTool.diffCode("q-1-dddd", "q-1-ddas"));
    }
}

