package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * @author fengyibo
 * @date 2018/7/19 14:44
 */
public enum SaasGrantOperEnum {
    ORDER(1,"订购"),
    RENEWAL_FEE(2,"续费"),
    UPGRADE(3,"升级"),
    REFUSE(4,"降级");

    private static final Map<Integer, SaasGrantOperEnum> enumMap = new HashMap<>();
    static{
        for(SaasGrantOperEnum saasGrantOperEnum : values()){
            enumMap.put(saasGrantOperEnum.getValue(), saasGrantOperEnum);
        }
    }

    public static SaasGrantOperEnum getByCode(Integer code) throws BizException {
        SaasGrantOperEnum saasGrantOperEnum = enumMap.get(code);
        if(saasGrantOperEnum == null){
            throw new BizException("不支持的功能类型");
        }
        return saasGrantOperEnum;
    }

    SaasGrantOperEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private int value;

    private String desc;

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
