package cn.com.duiba.developer.center.api.remoteservice.devapp;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.DevAppTrustConfDto;
import cn.com.duiba.developer.center.api.domain.dto.PageDto;

/**
 * Created by ChenXiangge on 21/05/2018.
 */
@AdvancedFeignClient
public interface RemoteDevAppService {
    int insertAppTrustConf(DevAppTrustConfDto appTrustConf);

    int deleteDevAppConf(Long id);

    PageDto<DevAppTrustConfDto> listPage(int pageNo, int pageSize);

    DevAppTrustConfDto findByAppid(Long appid);

    int updateAppStatus(DevAppTrustConfDto appTrustConf);

    /**
     * 判断是否开启自定义会员体系白名单
     */
    Boolean hasOpenVipExchange(Long appId)  throws BizException;
}
