package cn.com.duiba.developer.center.api.domain.enums.sms;

/**
 * @ClassName ErrorCodeEnum
 * @Description 错误码枚举
 * @Author zhoujunquan@duiba.com.cn
 * @Date 2021/3/3 12:10 下午
 * @Version 1.0
 **/
public enum ErrorCodeEnum {
    /**
     * 错误码
     */
    E40001("40001", "短信模板id有误"),
    E40002("40002", "手机号码有误"),
    E40003("40003", "您的短信发送过于频繁，请稍后再试"),
    E40004("40004", "验证码已失效"),
    E40005("40005", "验证码错误"),
    E40006("40006", "验证码发送失败"),
    ;

    private String code;

    private String msg;

    ErrorCodeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}