package cn.com.duiba.developer.center.api.domain.enums.sms;

import cn.com.duiba.boot.exception.BizException;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * @ClassName TemplateEnum
 * @Description 模板枚举
 * @Author zhoujunquan@duiba.com.cn
 * @Date 2021/3/3 11:51 上午
 * @Version 1.0
 **/
public enum TemplateEnum {
    /**
     * 模板id枚举
     */
    TEMPLATE_51(51L, SignIdEnum.SIGN_ID_3, SmsTypeEnum.VERIFICATION_CODE, 6
            , 10, 3, 10),
    ;

    private Long templateId;

    private SignIdEnum signIdEnum;

    private SmsTypeEnum smsTypeEnum;

    private Integer size;

    private Integer period;

    private Integer h1Limit;

    private Integer d1Limit;

    TemplateEnum(Long templateId, SignIdEnum signIdEnum, SmsTypeEnum smsTypeEnum
            , int size, int period, int h1Limit, int d1Limit) {
        this.templateId = templateId;
        this.signIdEnum = signIdEnum;
        this.smsTypeEnum = smsTypeEnum;
        this.size = size;
        this.period = period;
        this.h1Limit = h1Limit;
        this.d1Limit = d1Limit;
    }

    public static TemplateEnum getByCode(Long templateId) throws BizException {
        Optional<TemplateEnum> optional = Arrays.stream(TemplateEnum.values()).filter(
                t -> Objects.equals(t.templateId, templateId)).findAny();
        if (optional.isPresent()) {
            return optional.get();
        } else {
            throw new BizException(ErrorCodeEnum.E40001.getMsg()).withCode(ErrorCodeEnum.E40001.getCode());
        }
    }

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public SignIdEnum getSignIdEnum() {
        return signIdEnum;
    }

    public void setSignIdEnum(SignIdEnum signIdEnum) {
        this.signIdEnum = signIdEnum;
    }

    public SmsTypeEnum getSmsTypeEnum() {
        return smsTypeEnum;
    }

    public void setSmsTypeEnum(SmsTypeEnum smsTypeEnum) {
        this.smsTypeEnum = smsTypeEnum;
    }

    public Integer getSize() {
        return size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getPeriod() {
        return period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public Integer getH1Limit() {
        return h1Limit;
    }

    public void setH1Limit(Integer h1Limit) {
        this.h1Limit = h1Limit;
    }

    public Integer getD1Limit() {
        return d1Limit;
    }

    public void setD1Limit(Integer d1Limit) {
        this.d1Limit = d1Limit;
    }
}