package cn.com.duiba.developer.center.api.remoteservice.sms;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.message.service.api.dto.SmsSendInvoiceV2;

import java.util.Map;

/**
 * @InterfaceName RemoteSmsService
 * @Description 中台短信接口
 * @Author zhoujunquan@hzchuangbo.com
 * @Date 2021/3/3 11:20 上午
 * @Version 1.0
 **/
public interface RemoteSmsService {

    /**
     * 发送单条验证码短信
     *
     * @param mobile        手机号
     * @param templateId    模板id
     * @param templateParam 占位符键值对 就一个code的话传null
     * @return 短信发送结果 {@link SmsSendInvoiceV2}
     * @throws BizException
     * @desc 验证码的占位符固定是code
     */
    SmsSendInvoiceV2 sendVerificationCode(String mobile, Long templateId, Map<String, String> templateParam)
            throws BizException;

    /**
     * 发送单条通知短信
     *
     * @param mobile        手机号
     * @param templateId    模板id
     * @param templateParam 占位符键值对
     * @return 短信发送结果 {@link SmsSendInvoiceV2}
     * @throws BizException
     */
    SmsSendInvoiceV2 sendNotice(String mobile, Long templateId, Map<String, String> templateParam) throws BizException;

    /**
     * 验证码校验
     *
     * @param mobile     发送手机号
     * @param code       验证码
     * @param templateId 模板id
     * @throws BizException
     */
    void checkVerifyCode(String mobile, String code, Long templateId) throws BizException;
}