package cn.com.duiba.developer.center.api.utils;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.developer.center.api.domain.enums.sms.ErrorCodeEnum;

/**
 * @ClassName Conditions
 * @Description 异常判断简化
 * @Author zhoujunquan@duiba.com.cn
 * @Date 2021/3/3 12:50 下午
 * @Version 1.0
 **/
public class Conditions {
    public static void expectTrue(boolean expression, ErrorCodeEnum errorCode) throws BizException {
        if (!expression) {
            throw new BizException(errorCode.getMsg()).withCode(errorCode.getCode());
        }
    }

    public static void expectFalse(boolean expression, ErrorCodeEnum errorCode) throws BizException {
        if (expression) {
            throw new BizException(errorCode.getMsg()).withCode(errorCode.getCode());
        }
    }
}