package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * @author fengyibo
 * @date 2018/8/20 11:22
 */
public enum AccountTypeEnum {
    /**
     * 账户类型
     */
    PHONE(0,"手机号"),
    EMAIL(1,"邮箱号"),
    SUB_ACCOUNT(2,"子账号");

    private static final Map<Integer, AccountTypeEnum> enumMap = new HashMap<>();
    static{
        for(AccountTypeEnum accountTypeEnum : values()){
            enumMap.put(accountTypeEnum.getValue(), accountTypeEnum);
        }
    }

    public static AccountTypeEnum getByCode(Integer code){
        AccountTypeEnum accountTypeEnum = enumMap.get(code);
        if(accountTypeEnum == null){
            throw new DeveloperCenterException("不支持的状态类型");
        }
        return accountTypeEnum;
    }


    private int value;

    private String desc;

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    AccountTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }
}
