/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.domain.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum AppPaychannelEnum {
    ALIPAY(0, "alipay", "\u652f\u4ed8\u5b9d\u652f\u4ed8"),
    WXPAY(1, "wxpay", "\u5fae\u4fe1\u652f\u4ed8"),
    LITEPAY(2, "litepay", "\u5c0f\u7a0b\u5e8f\u652f\u4ed8");

    private Integer code;
    private String type;
    private String desc;
    private static Map<String, AppPaychannelEnum> typeMap;

    public static AppPaychannelEnum getAppPaychannelByType(String type) {
        if (type == null || !typeMap.containsKey(type)) {
            return null;
        }
        return typeMap.get(type);
    }

    public static List<AppPaychannelEnum> getOpenChannelListBySwitch(Long appPayChannelSwitch) {
        ArrayList<AppPaychannelEnum> list = new ArrayList<AppPaychannelEnum>();
        for (AppPaychannelEnum typeEnum : AppPaychannelEnum.values()) {
            if (!AppPaychannelEnum.isSwitch(typeEnum.getCode(), appPayChannelSwitch)) continue;
            list.add(typeEnum);
        }
        return list;
    }

    public static boolean isSwitch(int boundType, Long appPayChannelSwitch) {
        long v = 1 << boundType;
        long ret = appPayChannelSwitch & v;
        return ret != 0L;
    }

    private AppPaychannelEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getType() {
        return this.type;
    }

    static {
        typeMap = new HashMap<String, AppPaychannelEnum>();
        for (AppPaychannelEnum typeEnum : AppPaychannelEnum.values()) {
            typeMap.put(typeEnum.getType(), typeEnum);
        }
    }
}

