/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.utils;

import cn.com.duiba.developer.center.api.domain.dto.authority.BusinessWhiteListContentDto;
import cn.com.duiba.developer.center.api.domain.dto.authority.BusinessWhiteListDto;
import cn.com.duiba.developer.center.api.domain.enums.authority.AccessStatusType;
import cn.com.duiba.developer.center.api.domain.enums.authority.BusinessWhiteListType;
import cn.com.duiba.developer.center.api.remoteservice.authority.RemoteBusinessWhiteListContentService;
import cn.com.duiba.developer.center.api.remoteservice.authority.RemoteBusinessWhiteListService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class WhiteAccessUtil {
    private static Logger logger = LoggerFactory.getLogger(WhiteAccessUtil.class);
    private static RemoteBusinessWhiteListContentService remoteBusinessWhiteListContentService;
    private static RemoteBusinessWhiteListService remoteBusinessWhiteListService;
    private static StringRedisTemplate stringRedisTemplate;
    private static String EXITST;
    private static String NOT_EXITST;
    public static String PREFIX;
    public static String PREFIX_SINGLE;
    public static String PREFIX_JSON;
    private static final Cache<String, Boolean> CAN_ACCESS_WHITE_LIST;
    private static final Cache<String, String> WHITE_LIST_JSON_VALUE;
    private static final Cache<String, List<String>> WHITE_LIST_VALUES;

    public static String selectWhiteListJsonConfig(String uniqueCode) {
        return (String)WHITE_LIST_JSON_VALUE.get((Object)uniqueCode, code -> {
            String uniqueCodeKey = PREFIX_JSON + code;
            try {
                String jsonValue = (String)stringRedisTemplate.opsForValue().get((Object)uniqueCodeKey);
                if (jsonValue == null) {
                    BusinessWhiteListDto whiteListConfig = remoteBusinessWhiteListService.getByCode((String)code);
                    if (whiteListConfig == null || !BusinessWhiteListType.JSON_VALUE.getCode().equals(whiteListConfig.getBizType())) {
                        logger.warn("WHITE_LIST_JSON_VALUE  \u9519\u8bef \u8bf7\u6838\u5bf9 queryParam = {}", code);
                        return null;
                    }
                    BusinessWhiteListContentDto dto = remoteBusinessWhiteListContentService.getByRelId(whiteListConfig.getId());
                    if (dto != null && StringUtils.isNotBlank((CharSequence)dto.getBizContent())) {
                        stringRedisTemplate.opsForValue().set((Object)uniqueCodeKey, (Object)dto.getBizContent());
                        stringRedisTemplate.expire((Object)uniqueCode, 12L, TimeUnit.HOURS);
                        return dto.getBizContent();
                    }
                    return null;
                }
                return jsonValue;
            }
            catch (Exception e) {
                logger.warn("\u767d\u540d\u5355\u67e5\u8be2\u5931\u8d25\u3002\u8d70\u9ed8\u8ba4\u964d\u7ea7\u7b56\u7565 false equryParam = {}", code, (Object)e);
                return null;
            }
        });
    }

    public static Boolean matchWhiteList(Long appId, String uniqueCode) {
        String appIdCode = appId.toString() + "#" + uniqueCode;
        return (Boolean)CAN_ACCESS_WHITE_LIST.get((Object)appIdCode, appIdCodeStr -> {
            String[] data = appIdCodeStr.split("#");
            String code = data[1];
            String appIdStr = data[0];
            String uniqueCodeKey = PREFIX_SINGLE + code;
            try {
                Object score = stringRedisTemplate.opsForHash().get((Object)uniqueCodeKey, (Object)appIdStr);
                if (score == null) {
                    BusinessWhiteListDto whiteListConfig = remoteBusinessWhiteListService.getByCode(code);
                    if (whiteListConfig == null || AccessStatusType.CLOSE.getCode().equals(whiteListConfig.getOpenStatus()) || BusinessWhiteListType.JSON_VALUE.getCode().equals(whiteListConfig.getBizType())) {
                        logger.info("\u767d\u540d\u5355\u7c7b\u578b\u67e5\u8be2\u9519\u8bef\uff0c\u8bf7\u6838\u5bf9 queryParam = {}", appIdCodeStr);
                        stringRedisTemplate.opsForHash().put((Object)uniqueCodeKey, (Object)appIdStr, (Object)NOT_EXITST);
                        return false;
                    }
                    Boolean wasExist = remoteBusinessWhiteListContentService.getByRelIdAndValue(whiteListConfig.getId(), appId) != null;
                    stringRedisTemplate.opsForHash().put((Object)uniqueCodeKey, (Object)appIdStr, (Object)(wasExist != false ? EXITST : NOT_EXITST));
                    stringRedisTemplate.expire((Object)uniqueCodeKey, 12L, TimeUnit.HOURS);
                    return wasExist;
                }
                return EXITST.equals(String.valueOf(score));
            }
            catch (Exception e) {
                logger.warn("\u767d\u540d\u5355\u67e5\u8be2\u5931\u8d25\u3002\u8d70\u9ed8\u8ba4\u964d\u7ea7\u7b56\u7565 false equryParam = {}", appIdCodeStr, (Object)e);
                return false;
            }
        });
    }

    public static List<String> selectWhiteListConfig(String uniqueCode) {
        return (List)WHITE_LIST_VALUES.get((Object)uniqueCode, code -> {
            String uniqueCodeKey = PREFIX + code;
            try {
                String jsonValue = (String)stringRedisTemplate.opsForValue().get((Object)uniqueCodeKey);
                if (jsonValue == null) {
                    ArrayList values = Lists.newArrayList();
                    BusinessWhiteListDto whiteListConfig = remoteBusinessWhiteListService.getByCode((String)code);
                    if (whiteListConfig == null) {
                        logger.warn("fetchWhiteListValues code \u9519\u8bef \u8bf7\u6838\u5bf9 queryParam = {}", code);
                        return values;
                    }
                    if (BusinessWhiteListType.JSON_VALUE.getCode().equals(whiteListConfig.getBizType())) {
                        logger.warn("WHITE_LIST_JSON_VALUE \u767d\u540d\u5355json\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u6838\u5bf9 queryParam = {}", code);
                        return values;
                    }
                    List<BusinessWhiteListContentDto> dtos = remoteBusinessWhiteListContentService.getByRid(whiteListConfig.getId());
                    if (CollectionUtils.isNotEmpty(dtos)) {
                        values.addAll(dtos.stream().map(a -> a.getRelValue()).collect(Collectors.toList()));
                        stringRedisTemplate.opsForValue().set((Object)uniqueCodeKey, (Object)JSON.toJSONString((Object)values));
                        stringRedisTemplate.expire((Object)uniqueCodeKey, 12L, TimeUnit.HOURS);
                    }
                    return values;
                }
                return JSONArray.parseArray((String)jsonValue, String.class);
            }
            catch (Exception e) {
                logger.warn("\u767d\u540d\u5355\u67e5\u8be2\u5931\u8d25\u3002\u8d70\u9ed8\u8ba4\u964d\u7ea7\u7b56\u7565 false equryParam = {}", code, (Object)e);
                return Lists.newArrayList();
            }
        });
    }

    private WhiteAccessUtil() {
    }

    public static StringRedisTemplate getStringRedisTemplate() {
        return stringRedisTemplate;
    }

    public static void setStringRedisTemplate(StringRedisTemplate stringRedisTemplate) {
        WhiteAccessUtil.stringRedisTemplate = stringRedisTemplate;
    }

    public static RemoteBusinessWhiteListContentService getRemoteBusinessWhiteListContentService() {
        return remoteBusinessWhiteListContentService;
    }

    public static void setRemoteBusinessWhiteListContentService(RemoteBusinessWhiteListContentService remoteBusinessWhiteListContentService) {
        WhiteAccessUtil.remoteBusinessWhiteListContentService = remoteBusinessWhiteListContentService;
    }

    public static RemoteBusinessWhiteListService getRemoteBusinessWhiteListService() {
        return remoteBusinessWhiteListService;
    }

    public static void setRemoteBusinessWhiteListService(RemoteBusinessWhiteListService remoteBusinessWhiteListService) {
        WhiteAccessUtil.remoteBusinessWhiteListService = remoteBusinessWhiteListService;
    }

    static {
        EXITST = "1";
        NOT_EXITST = "0";
        PREFIX = "WHITE_LIST_";
        PREFIX_SINGLE = "WHITE_LIST_SINGLE";
        PREFIX_JSON = "WHITE_LIST_JSON";
        CAN_ACCESS_WHITE_LIST = Caffeine.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).maximumSize(1000L).build();
        WHITE_LIST_JSON_VALUE = Caffeine.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).maximumSize(1000L).build();
        WHITE_LIST_VALUES = Caffeine.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).maximumSize(1000L).build();
    }

    public static class QueryParam {
        private Long appId;
        private String uniqueCode;

        public Long getAppId() {
            return this.appId;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }

        public String getUniqueCode() {
            return this.uniqueCode;
        }

        public void setUniqueCode(String uniqueCode) {
            this.uniqueCode = uniqueCode;
        }

        public QueryParam(Long appId, String uniqueCode) {
            this.appId = appId;
            this.uniqueCode = uniqueCode;
        }

        public QueryParam(String uniqueCode) {
            this.uniqueCode = uniqueCode;
        }
    }
}

