/**
 * Project Name:developer-center-api File Name:AppBannerDto.java Package
 * Name:cn.com.duiba.developer.center.api.domain.dto Date:2016年8月10日下午8:24:22 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.developer.center.api.domain.dto;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;

import java.util.Date;
import java.util.Map;

import static cn.com.duiba.developer.center.api.domain.enums.UploadImageEnum.BANNER_IMAGE_NEW;

/**
 * ClassName:AppBannerDto <br/>
 * Date: 2016年8月10日 下午8:24:22 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public class AppBannerDto extends BaseDto {

    private static final long serialVersionUID = -4520979971977839662L;

    private Long              id;

    private Long              appId;

    private Integer           payload;

    private String            image;

    private String            name;

    private String            url;

    private String            type;

    private Integer           sourceType;                              // 来源类型

    private Long              sourceRelationId;                        // 来源管理对象主键id

    private Boolean           deleted;

    private Long              appItemId;

    private String            classifyImage;                           // 分类列表表头图片

    private Boolean           classifyImageSwitch;                     // 分类列表表头图片显示开关

    private Date              activityStartDate;//活动开始时间

    private Date              activityEndDate;//活动结束时间

    private Date              gmtCreate;

    private Date              gmtModified;

    //json图片字符串
    private String imageJson;

    private Map<String, String> imageJsonMap = Maps.newHashMap();

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getPayload() {
        return payload;
    }

    public void setPayload(Integer payload) {
        this.payload = payload;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceRelationId() {
        return sourceRelationId;
    }

    public void setSourceRelationId(Long sourceRelationId) {
        this.sourceRelationId = sourceRelationId;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public String getClassifyImage() {
        return classifyImage;
    }

    public void setClassifyImage(String classifyImage) {
        this.classifyImage = classifyImage;
    }

    public Boolean getClassifyImageSwitch() {
        return classifyImageSwitch;
    }

    public void setClassifyImageSwitch(Boolean classifyImageSwitch) {
        this.classifyImageSwitch = classifyImageSwitch;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getActivityStartDate() {
        return activityStartDate;
    }

    public void setActivityStartDate(Date activityStartDate) {
        this.activityStartDate = activityStartDate;
    }

    public Date getActivityEndDate() {
        return activityEndDate;
    }

    public void setActivityEndDate(Date activityEndDate) {
        this.activityEndDate = activityEndDate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getImageJson() {
        return imageJson;
    }

    public void setImageJson(String imageJson) {
        this.imageJson = imageJson;
    }

    public String getImageJsonMap() {
        return JSON.toJSONString(imageJsonMap);
    }

    public void setImageJsonMap(Map<String, String> imageJsonMap) {
        this.imageJsonMap = imageJsonMap;
    }

    public String getBannerImgNew() {
        if (StringUtils.isNotBlank(this.imageJson)) {
            return JSON.parseObject(imageJson, new TypeReference<Map<String, String>>() {
            }).get(BANNER_IMAGE_NEW.getCode());
        }

        return StringUtils.EMPTY;
    }

    public void setBannerImgNew(String bannerImgNew) {
        imageJsonMap.put(BANNER_IMAGE_NEW.getCode(), bannerImgNew);
    }
}
