package cn.com.duiba.developer.center.api.domain.dto.authority;

import java.io.Serializable;
import java.util.List;

/**
 * @author liukai
 * @Description: 权限树列表
 * @date 2019/8/1910:10 AM
 */

public class DeveloperNewPowerListDto implements Serializable {


    private static final long serialVersionUID = 8811947175725527235L;


    /**
     * 整理好的权限数组字符串["1-2-3","2-3-4"]
     */
    private List<String> parserTree;


    private List<ListBean> list;



    public static class ListBean implements Serializable{
        private static final long serialVersionUID = -2187819693483748319L;
        /**
         * id
         */
        private Long id;
        /**
         * 资源名称
         */
        private String resourcesName;
        /**
         * 权限列表   一期默认运营添加后，都有对应资源的权限
         */
        private List<AuthoritysTreeBean> authoritysTree;



        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getResourcesName() {
            return resourcesName;
        }

        public void setResourcesName(String resourcesName) {
            this.resourcesName = resourcesName;
        }

        public List<AuthoritysTreeBean> getAuthoritysTree() {
            return authoritysTree;
        }

        public void setAuthoritysTree(List<AuthoritysTreeBean> authoritysTree) {
            this.authoritysTree = authoritysTree;
        }
    }

    public List<String> getParserTree() {
        return parserTree;
    }

    public void setParserTree(List<String> parserTree) {
        this.parserTree = parserTree;
    }

    public List<ListBean> getList() {
        return list;
    }

    public void setList(List<ListBean> list) {
        this.list = list;
    }


    public static class AuthoritysTreeBean implements Serializable{

        private static final long serialVersionUID = 4817595241425497900L;
        /**
         * id : 权限id
         */
        private Long id;

        /**
         * 权限名称
         */
        private String authorityName;

        /**
         * 权限列表
         */
        private List<AuthorityEntityBean> powerList;


        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getAuthorityName() {
            return authorityName;
        }

        public void setAuthorityName(String authorityName) {
            this.authorityName = authorityName;
        }

        public List<AuthorityEntityBean> getPowerList() {
            return powerList;
        }

        public void setPowerList(List<AuthorityEntityBean> powerList) {
            this.powerList = powerList;
        }
    }
}
