package cn.com.duiba.developer.center.api.domain.enums;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by sty on 2017/5/9.
 */
public enum AppIconStatusEnum {
    STATUS_OPEN(1, "开启"),
    STATUS_CLOSED(0, "关闭");

    private Integer code;
    private String desc;

    private static Map<Integer, AppIconStatusEnum> typeMap = new HashMap<>();

    static {
        for (AppIconStatusEnum typeEnum : values()) {
            typeMap.put(typeEnum.getCode(), typeEnum);
        }
    }

    public static AppIconStatusEnum getAppIconStatusByCode(Integer code) {
        if (code == null || !typeMap.containsKey(code)) {
            throw new DeveloperCenterException("不支持的图标状态，status=" + code);
        }
        return typeMap.get(code);
    }


    AppIconStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }


    public String getDesc() {
        return desc;
    }

}
