package cn.com.duiba.developer.center.api.domain.enums.visualeditor;

import org.apache.commons.lang.ObjectUtils;

/**
 * Created by sunyan on 2019/4/29.
 * 商品/商品组组件库存不足显示类型
 */
public enum SoldOutTypeEnum {
    SHOW("show","显示"),
    SINK("sink","沉底"),
    HIDDEN("hidden","隐藏");

    private String type;
    private String desc;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    SoldOutTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static SoldOutTypeEnum getByType(String type){
        if(type == null){
            return null;
        }
        for(SoldOutTypeEnum soldOutTypeEnum:SoldOutTypeEnum.values()){
            if(ObjectUtils.equals(type,soldOutTypeEnum.getType())){
                return soldOutTypeEnum;
            }
        }
        return null;
    }
}
