package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.DlpIncomeMoneyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by ZQian on 2016/8/8.
 */
@AdvancedFeignClient
public interface RemoteDlpIncomeMoneyService {
    /**
     * 获取开发者收入(当前主体)
     * @param developId
     * @return
     */
    DubboResult<DlpIncomeMoneyDto> findIncomeMoney(Long developId);

    /**
     * 获取开发者收入(所有主体)
     * @param developerId
     * @return
     */
    List<DlpIncomeMoneyDto> listIncomeMoney(Long developerId);

    /**
     * 批量获取开发者收入(所有主体)
     * @param developerIds
     * @return
     */
    List<DlpIncomeMoneyDto> listIncomeMoneyByDeveloperIds(List<Long> developerIds);
}
