package cn.com.duiba.developer.center.api.remoteservice.extension;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.extension.DuibaExtensionDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteDuibaExtensionService {

    /**
     * 插入
     * @param duibaExtensionDto
     * @return
     */
    boolean insertExtension(DuibaExtensionDto duibaExtensionDto) throws BizException;

    /**
     * 根据手机号精准查找
     * @param phone
     * @return
     */
    DuibaExtensionDto getDuibaExtension(String phone) throws BizException;

    /**
     * 管理后端分页查询
     * @param phone
     * @param pageNum
     * @param pageSize
     * @return
     */
    List<DuibaExtensionDto> queryDuibaExtensionList(String phone, Integer pageNum, Integer pageSize) throws BizException;

    int count(String phone);
}
