package cn.com.duiba.developer.center.api.remoteservice.proxy;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.proxy.ReverseProxyCouponDto;

@AdvancedFeignClient
public interface RemoteReverseProxyService {
    ReverseProxyCouponDto addReverseProxy(Long itemId, String originalUrl, String targetUrl) throws BizException;

    /**
     * 设置需要反向代理的域名列表，注意域名不能包含星号，比如www.tuia.cn,
     * 注意：调用此方法会追加域名
     * 此接口调用后需要30秒后才能在网关生效。
     * @param proxyHost
     */
    Boolean appendHosts(String proxyHost);
}
