package cn.com.duiba.developer.center.api.remoteservice.risk;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.risk.PrizeGrantWarnDto;
import cn.com.duiba.developer.center.api.domain.dto.risk.PrizeGrantWarnPageDto;

import java.util.List;

/**
 * @author JunAngLiu
 * @Title: RemoteAccountExpendWarnService
 * @Description: app账户支出预警配置
 * @date 2019/4/2811:27
 */
@AdvancedFeignClient
public interface RemotePrizeGrantWarnService {

    /**
     * 条件插入数据
     * @param record
     * @return
     */
    int insertSelective(PrizeGrantWarnDto record);

    /**
     * 根据主键查询
     * @param id
     * @return
     */
    PrizeGrantWarnDto selectByPrimaryKey(Long id);

    /**
     * 根据主键 条件更新
     * @param record
     * @return
     */
    int updateByPrimaryKeySelective(PrizeGrantWarnDto record);

    /**
     * 根据条件 计算总数
     * @param dto
     * @return
     */
    Integer countByConditions(PrizeGrantWarnPageDto dto);

    /**
     * 根据条件查询 列表
     * @return
     */
    List<PrizeGrantWarnDto> queryListByConditons(PrizeGrantWarnPageDto dto);

    /**
     * 分页查询
     * @return
     */
    Page<PrizeGrantWarnDto> queryPageByconditions(PrizeGrantWarnPageDto dto);

    /**
     * 校验 兑换项是否存在
     * @return
     */
    Boolean validWithCache(PrizeGrantWarnPageDto dto);
}
