package cn.com.duiba.developer.center.api.remoteservice.strategy;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.strategy.StrategyDynamicDataDto;

import java.util.List;

/**
 * 动态类型数据-远程服务接口
 *
 * @Author: xuwei
 * @Date: 2020/05/27
 */
@AdvancedFeignClient
public interface RemoteStrategyDynamicDataService {
    /**
     * 根据ID查询
     *
     * @param id
     * @return
     */
    StrategyDynamicDataDto findById(Long id);

    /**
     * 根据指定类型列表查询
     *
     * @param types
     * @return
     */
    List<StrategyDynamicDataDto> findByTypes(List<Integer> types);

    /**
     * 根据上级和指定类型查询
     *
     * @param parent
     * @param type
     * @return
     */
    List<StrategyDynamicDataDto> findByParentAndType(Long parent, Integer type);

    /**
     * 根据指定id列表查询
     *
     * @param ids
     * @return
     */
    List<StrategyDynamicDataDto> findByIds(List<Long> ids);

    /**
     * 插入记录
     *
     * @param record
     * @return code
     */
    Long insert(StrategyDynamicDataDto record);

    /**
     * 批量插入
     *
     * @param records
     */
    void batchInsert(List<StrategyDynamicDataDto> records);
}