package cn.com.duiba.developer.center.api.remoteservice.visualeditor;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.visualeditor.VisualEditorAppSkinDto;
import cn.com.duiba.developer.center.api.domain.dto.visualeditor.VisualEditorSimpleAppSkinDto;
import cn.com.duiba.developer.center.api.domain.param.VisualEditorAppSkinBatchParam;
import cn.com.duiba.developer.center.api.domain.param.VisualEditorAppSkinParam;
import cn.com.duiba.developer.center.api.domain.param.VisualEditorAppSkinQueryParam;

import java.util.List;

/**
 *
 * @author dugq
 * @date 2018/8/13
 */
@AdvancedFeignClient
public interface RemoteVisualEditorAppSkinService {

    Long insert(VisualEditorAppSkinDto pojo);

    List<VisualEditorAppSkinDto> select(VisualEditorAppSkinParam param);


    int selectCount(VisualEditorAppSkinParam param);


    /**
     * 开发者后台 条件查询 组件化皮肤列表数据
     * 已过滤 已删除数据
     * 按照 gmt_create 倒序排序
     * @param param
     * @return List
     */
    List<VisualEditorAppSkinDto> selectSkins(VisualEditorAppSkinQueryParam param);
    /**
     * 开发者后台 组件化页面 数量统计
     * 已过滤 已删除数据
     * @param param
     * @return int
     */
    int selectCountWithIndex(VisualEditorAppSkinQueryParam param);



    /**
     * 根据id查找
     * 1.不过滤delete 即被软删除的数据也会返回
     *
     * @param id
     * @return
     */
    VisualEditorAppSkinDto selectOne(Long id);

    int update(VisualEditorAppSkinDto pojo);

    int delete(Long id);

    /**
     * 根据皮肤id获取皮肤简单信息，包括组件列表 使用了缓存
     * @param skinId 皮肤id
     * @return
     */
    VisualEditorSimpleAppSkinDto selectSimpleAppSkinDtoBySkinIdWithCache(Long skinId);

    /**
     * 获取皮肤预览的简单信息，包括预览的组件信息   预览 ： 数据库存了一条新的皮肤数据，parentId指向线上数据
     * 如果没有创建预览数据，则调用selectSimpleAppSkinDtoBySkinIdWithCache 方法获取线上数据
     * @param skinId
     * @return
     */
    VisualEditorSimpleAppSkinDto selectCopySimpleAppSkinDtoBySkinIdWithCache(Long skinId);
    /**
     * 根据appId查询商城首页
     * 一个app可以有多个页面，但首页有且只有一个
     * @param appId
     * @return
     */
    VisualEditorSimpleAppSkinDto selectIndexPageWithCache(Long appId);

    /**
     * 启用皮肤
     * 如果皮肤有预览数据，则将预览数据覆盖到源数据中
     * @param skinId
     * @return
     */
    int openAppSkin(Long skinId);

    /**
     * 跟换首页
     * @param appId
     * @param skinId
     * @return
     */
    int updateAppIndexSkin(Long appId, Long skinId) throws BizException;

    /**
     * 修改皮肤名称，无需上架，立即生效。
     * @param pojo
     * @return
     */
    int updateSkinName(VisualEditorAppSkinDto pojo);

    /**
     * 修改分享配置
     * @param dto
     * @return
     */
    int updateShareConfig(VisualEditorAppSkinDto dto);


    /**
     * 条件批量查询  皮肤列表
     * @param appIds
     * @param param
     * @return
     */
    List<VisualEditorAppSkinDto> batchFindByConditions(List<Long> appIds, VisualEditorAppSkinBatchParam param);

    List<VisualEditorAppSkinDto> selectBySkinIds(List<Long> skinIds);
}
