package cn.com.duiba.developer.center.api.utils;

import cn.com.duiba.developer.center.api.domain.dto.survey.OptionDto;
import cn.com.duiba.developer.center.api.domain.dto.survey.QuestionDto;
import cn.com.duiba.developer.center.api.domain.enums.survey.QuestionTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Objects;

public class QuestionDiffTool {
    private static final Logger LOG = LoggerFactory.getLogger(QuestionDiffTool.class);

    /**
     * 判断问题是否变了
     */
    public static boolean diff(List<QuestionDto> beforeQuestions, List<QuestionDto> afterQuestions) {
        if (diff(beforeQuestions.size(), afterQuestions.size(), "问题数量")) {
            return true;
        }
        for (int i = 0; i < beforeQuestions.size(); i++) {
            if (diffQuestion(beforeQuestions.get(i), afterQuestions.get(i))) {
                return true;
            }
        }
        return false;
    }


    private static boolean diff(Object before, Object after, String desc) {
        if (!Objects.equals(before, after)) {
            LOG.info("问题更新：{},before={},after={}", desc, before, after);
            return true;
        }
        return false;
    }

    private static boolean diffQuestion(QuestionDto before, QuestionDto after) {//NOSONAR
        if (diffCode(before.getCode(), after.getCode())) {
            return true;
        }

        if (diff(before.getType(), after.getType(), "问题类型")) {
            return true;
        }

        if (after.getTitle() != null) {
            if (diff(before.getTitle(), after.getTitle(), "问题标题")) {
                return true;
            }
        }

        if (after.getDescription() != null) {
            if (diff(before.getDescription(), after.getDescription(), "问题描述")) {
                return true;
            }
        }

        if (diff(before.getRequired(), after.getRequired(), "问题必填属性")) {
            return true;
        }

        if (after.getValidate() != null) {
            if (diff(before.getValidate(), after.getValidate(), "问题校验")) {
                return true;
            }
        }
        if (after.getDisplay() != null) {
            if (diff(before.getDisplay(), after.getDisplay(), "问题展示逻辑")) {
                return true;
            }

        }

        if (after.getJump() != null) {
            if (diff(before.getJump(), after.getJump(), "问题跳转逻辑")) {
                return true;
            }
        }

        if (before.getOptions() != null) {
            if (diffOptions(before.getOptions(), after.getOptions())) {
                return true;
            }
        }else if(after.getOptions()!=null){
            return true;
        }

        return false;
    }

    private static boolean diffOptions(List<OptionDto> beforeOptions, List<OptionDto> afterOptions) {
        if (diff(beforeOptions, afterOptions, "选项存在")) {
            return true;
        }
        if (diff(beforeOptions.size(), afterOptions.size(), "选项数量")) {
            return true;
        }
        for (int i = 0; i < beforeOptions.size(); i++) {
            if (diffOption(beforeOptions.get(i), afterOptions.get(i))) {
                return true;
            }
        }
        return false;
    }

    private static boolean diffOption(OptionDto before, OptionDto after) {
        if (diffCode(before.getCode(), after.getCode())) {
            return true;
        }
        if (diff(before.getTitle(), after.getTitle(), "选项题目")) {
            return true;
        }
        if (diff(before.getType(), after.getType(), "选项类型")) {
            return true;
        }
        if (after.getDisplay() != null) {
            if (diff(before.getDisplay(), after.getDisplay(), "选项展示逻辑")) {
                return true;
            }
        }

        if (after.getJump() != null) {
            if (diff(before.getJump(), after.getJump(), "选项跳转逻辑")) {
                return true;
            }
        }
        if (diff(before.getExclusive(), after.getExclusive(), "选项互斥")) {
            return true;
        }

        return false;
    }


    private static boolean diffCode(String before, String after) {
        String[] split = before.split("-");
        String[] split1 = after.split("-");
        for (int i = 0; i < 2; i++) {
            if (diff(split[i], split1[i], "编码")) {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println(diffCode("q-1-dddd", "q-1-ddas"));
    }
}
