package cn.com.duiba.developer.center.api.domain.dto.statistics;


import java.io.Serializable;

/**
 * 积分分布
 */
public class CreditsDistributionDto implements Serializable {
	private static final long serialVersionUID = -21313212672L;

	//from CSVData.CSV_SEPARTOR
	private static final String CSV_SEPARTOR = ",";

	private String section;

	private Long num;

	/**
	 * 无参构造
	 */
	public CreditsDistributionDto(){
		this.section = "";
		this.num = 0L;
	}

	/**
	 * 构造出一个积分段数量
	 * @param section 积分段
	 * @param num 数量
     */
	public CreditsDistributionDto(String section, Long num) {
		this.section = section;
		this.num = num;
	}

	public String getSection() {
		return section;
	}

	public void setSection(String section) {
		this.section = section;
	}

	public Long getNum() {
		return num;
	}

	public void setNum(Long num) {
		this.num = num;
	}

	@Override
	public String toString() {
		return "MonthPvUvVO [section=" + section + ", num=" + num + "]";
	}

	/**
	 * 转化成行级CSV
	 * @return 行级CSV字符串
     */
	public String toCSVLine(){
	    return " "+section+CSV_SEPARTOR+num;
	}


}
