package cn.com.duiba.developer.center.api.domain.enums.crm;

import java.util.HashMap;
import java.util.Map;

/**
 * @author haojiahong
 * @date 2020-06-16
 */
public enum ClueAppProjectStageEnum {

    COMMUNICATE(1, "沟通阶段"),
    ASSESSMENT(2, "初评报价"),
    CONFIRM(3, "确认合作"),
    DEVELOP(4, "开发中"),
    ONLINE(5, "已上线"),
    DENY(6, "不合作"),
    ;


    private static final Map<Integer, ClueAppProjectStageEnum> enumMap = new HashMap<>();
    static{
        for(ClueAppProjectStageEnum clueAppProjectStageEnum : values()){
            enumMap.put(clueAppProjectStageEnum.getCode(), clueAppProjectStageEnum);
        }
    }

    public static ClueAppProjectStageEnum getByCode(Integer code){
        ClueAppProjectStageEnum clueAppProjectStageEnum = enumMap.get(code);
        if(clueAppProjectStageEnum == null){
            return null;
        }
        return clueAppProjectStageEnum;
    }

    private Integer code;
    private String desc;

    ClueAppProjectStageEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
