package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.PhonebillListDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by zhengjy on 2016/09/05
 */
@AdvancedFeignClient
public interface RemotePhoneBillListsService {
	/**
	 * 获取话费和展示价格列表
	 * @param mobile
	 * @param facePrice
     * @return
     */
	public DubboResult<List<PhonebillListDto>> findByMobileAndFacePrice(String mobile, Integer facePrice);

	/**
	 * 获取的所有话费的展示 价格
	 * @param facePrices
	 * @return
     */
	public DubboResult<List<PhonebillListDto>> findAllInFacePrice(List<Integer> facePrices);

	/**
	 * 获取话费列表
	 * @param price
	 * @param mobile
     * @return
     */
	public DubboResult<PhonebillListDto> findByFacePriceAndMobile(Integer price ,String mobile);

	/**
	 * 获取所有话费列表
	 * @return
     */
	public DubboResult<List<PhonebillListDto>> findAll();

	/**
	 * 删除话费列表
	 * @param id
     */
	public void delete(Long id);

	/**
	 * 插入话费
	 * @param phonebillListDO
     */
	public void insert(PhonebillListDto phonebillListDO);

	/**
	 * 更新话费
	 * @param phonebillListDO
     */
	public void update(PhonebillListDto phonebillListDO);

	/**
	 * 查询单个话费
	 * @param id
	 * @return
     */
	public DubboResult<PhonebillListDto> find(Long id);

	List<PhonebillListDto> findByFacePriceAndMobileProvince(String mobile, Integer facePrice, String province);
}
