/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.aspectj;

import cn.com.duiba.developer.center.api.aspectj.WhiteListProperties;
import cn.com.duiba.developer.center.api.domain.dto.codereport.WhiteListCodePositionDto;
import cn.com.duiba.developer.center.api.remoteservice.codereport.RemoteWhiteListCodeReportService;
import cn.com.duiba.developer.center.api.utils.MD5;
import cn.com.duiba.developer.center.api.utils.WhiteAccessUtil;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@EnableConfigurationProperties(value={WhiteListProperties.class})
@Component
@ConditionalOnClass(value={WhiteAccessUtil.class})
@ConditionalOnProperty(name={"white.list.reportCodeopenSwitch"}, havingValue="1", matchIfMissing=false)
public class CustomCodeReportRunner
implements CommandLineRunner {
    public static final List<WhiteListCodePositionDto> whiteListCodePositions = Lists.newArrayList();
    private static final Logger logger = LoggerFactory.getLogger(CustomCodeReportRunner.class);
    @Resource
    private ExecutorService executorService;
    @Autowired
    private Environment environment;
    @Autowired
    private RemoteWhiteListCodeReportService remoteWhiteListCodeReportService;

    public void run(String ... args) throws Exception {
        logger.info("\u81ea\u52a8\u4e0a\u62a5\u5b9a\u5236\u4ee3\u7801 \u5f00\u59cb");
        String sysName = this.environment.getProperty("spring.application.name");
        this.executorService.submit(() -> {
            this.remoteWhiteListCodeReportService.deleteBySystemName(sysName);
            logger.info("\u81ea\u52a8\u4e0a\u62a5\u5b9a\u5236\u4ee3\u7801 total = {}", (Object)whiteListCodePositions.size());
            List lists = Lists.partition(whiteListCodePositions, (int)20);
            for (List whiteListCodePositionDtos : lists) {
                this.remoteWhiteListCodeReportService.batchSave(whiteListCodePositionDtos);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    logger.error("\u81ea\u52a8\u4e0a\u62a5\u5b9a\u5236\u4ee3\u7801\u5f00\u59cb \u5931\u8d25", (Throwable)e);
                }
            }
            logger.info("\u81ea\u52a8\u4e0a\u62a5\u5b9a\u5236\u4ee3\u7801 end = {}", (Object)whiteListCodePositions.size());
            whiteListCodePositions.clear();
        });
    }

    public static void collectPositionObject(String sysName, String className, String description, String value, List<WhiteListCodePositionDto> whiteListCodePositionDtoLists) {
        WhiteListCodePositionDto whiteListCodePositionDto = new WhiteListCodePositionDto();
        whiteListCodePositionDto.setCodePosition(className);
        whiteListCodePositionDto.setComment(description);
        whiteListCodePositionDto.setWhiteListKey(value);
        whiteListCodePositionDto.setSysName(sysName);
        whiteListCodePositionDto.setMd5Str(CustomCodeReportRunner.getMd5Str(value, sysName, className));
        whiteListCodePositionDtoLists.add(whiteListCodePositionDto);
    }

    public static String getMd5Str(String value, String sysName, String className) {
        return MD5.md5(value + sysName + className);
    }
}

