package cn.com.duiba.developer.center.api.domain.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 业务功能导出枚举
 * author zhanghuifeng
 * date 2018-12-06-14:18
 */
public enum BusinessExportTypeEnum {
    APP_ACCOUNT_DETAIL(1, "开发者应用账户明细导出"),
    ORDER(2, "订单导出"),
    GENIE_CHART(3,"智能分析系统图表数据导出"),
    ;
    private Integer code;

    private String desc;

    BusinessExportTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, BusinessExportTypeEnum> enumMap = new HashMap<>();
    static{
        for(BusinessExportTypeEnum businessExportTypeEnum : values()){
            enumMap.put(businessExportTypeEnum.getCode(), businessExportTypeEnum);
        }
    }

    public static BusinessExportTypeEnum getByCode(Integer code){
        BusinessExportTypeEnum businessExportTypeEnum = enumMap.get(code);
        if(businessExportTypeEnum == null){
            return null;
        }
        return businessExportTypeEnum;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
