/**
 * Project Name:developer-center-api File Name:AppPushTaskDto.java Package
 * Name:cn.com.duiba.developer.center.api.domain.dto Date:2016年11月2日下午9:33:20 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.developer.center.api.domain.dto;

import cn.com.duiba.developer.center.api.domain.enums.AppPushStatusEnum;
import cn.com.duiba.developer.center.api.domain.enums.PushSourceTypeEnum;
import cn.com.duiba.developer.center.api.domain.enums.PushTypeEnum;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * ClassName:AppPushTaskDto <br/>
 * Date: 2016年11月2日 下午9:33:20 <br/>
 * @author zhanglihui
 * @since JDK 1.7
 * @see
 */
public class AppPushTaskDto extends BaseDto {

    private static final long   serialVersionUID = -7793988823067648079L;

    /** APP计划任务主键 */
    private Long                id;

    /** 管理员计划任务主键 */
    private Long                duibaTaskId;

    /**计划任务标题*/
    private String               title;

    /** 推送内容主键 */
    private Long                sourceId;

    /** 推送内容类型 {@link PushSourceTypeEnum} */
    private String              sourceType;

    /**推送内容名称*/
    private String               sourceName;

    /** 推送应用ID */
    private Long                appId;

    /** 推送入口类型 {@link PushTypeEnum} */
    private List<String>        pushTypes;

    /** APP计划任务执行状态 {@link AppPushStatusEnum} */
    private String              status;

    /** 推送时间 */
    private Date                pushTime;

    /** 扩展字段 */
    private Map<String, String> extParam;

    private Boolean hiddenForDeveloper;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getDuibaTaskId() {
        return duibaTaskId;
    }

    public void setDuibaTaskId(Long duibaTaskId) {
        this.duibaTaskId = duibaTaskId;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public List<String> getPushTypes() {
        return pushTypes;
    }

    public void setPushTypes(List<String> pushTypes) {
        this.pushTypes = pushTypes;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getPushTime() {
        return pushTime;
    }

    public void setPushTime(Date pushTime) {
        this.pushTime = pushTime;
    }

    public Map<String, String> getExtParam() {
        return extParam;
    }

    public void setExtParam(Map<String, String> extParam) {
        this.extParam = extParam;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public Boolean getHiddenForDeveloper() {
        return hiddenForDeveloper;
    }

    public void setHiddenForDeveloper(Boolean hiddenForDeveloper) {
        this.hiddenForDeveloper = hiddenForDeveloper;
    }
}
