package cn.com.duiba.developer.center.api.aspectj;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.developer.center.api.domain.dto.codereport.WhiteListCodePositionDto;
import cn.com.duiba.developer.center.api.remoteservice.codereport.RemoteWhiteListCodeReportService;
import cn.com.duiba.developer.center.api.utils.MD5;
import cn.com.duiba.developer.center.api.utils.WhiteAccessUtil;
import cn.com.duiba.developer.center.api.utils.WhiteAccessUtilBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.ExecutorService;

/**
 * 这里通过CommandLineRunner，在spring 刷新完毕之后，启动一个处理
 *
 * @Author 刘凯
 * @Date 2022/7/27 11:37 上午 （可以根据需要修改）
 * @Version 1.0 （版本号）
 */
@Component
public class CustomCodeReportRunner implements CommandLineRunner {


    private static final Logger logger = LoggerFactory.getLogger(CustomCodeReportRunner.class);

    @Resource
    private ExecutorService executorService;

    @Resource
    private WhiteAccessUtilBase whiteAccessUtilBase;

    @Autowired
    private Environment environment;

    @Autowired
    private RemoteWhiteListCodeReportService remoteWhiteListCodeReportService;

    @Override
    public void run(String... args) throws Exception {
        logger.info("自动上报定制代码 开始");
        WhiteAccessUtilBase.sysName = environment.getProperty("spring.application.name");

        if (!SpringEnvironmentUtils.isProdEnv()) {
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.setTarget(whiteAccessUtilBase);
            proxyFactory.addAdvice(new WhiteAccessUtilBase.WhiteAccessMethodInterceptor());
            WhiteAccessUtil.whiteAccessUtilBase = (WhiteAccessUtilBase) proxyFactory.getProxy();
            WhiteAccessUtilBase.static_executorService = executorService;
            WhiteAccessUtilBase.static_codeservice = remoteWhiteListCodeReportService;
            logger.info("WhiteAccessUtilBase 代理设置完毕");
        } else {
            WhiteAccessUtil.whiteAccessUtilBase = whiteAccessUtilBase;
        }

    }

    /**
     * 在CustomReportCollectBeanPostProccess 中会扫描一轮 注解的类 还有
     * 方法上是否带有CustomCodePositionReport注解，将这些信息提前放入到whiteListCodePositionsInMethod
     * 与whiteListCodePositionInClass中
     *
     * @param className
     * @param description
     * @param value
     * @param whiteListCodePositionDtoLists
     */
    public static void collectPositionObject(String sysName, String className, String description, String value, List<WhiteListCodePositionDto> whiteListCodePositionDtoLists) {
        WhiteListCodePositionDto whiteListCodePositionDto = new WhiteListCodePositionDto();
        whiteListCodePositionDto.setCodePosition(className);
        whiteListCodePositionDto.setComment(description);
        whiteListCodePositionDto.setWhiteListKey(value);
        whiteListCodePositionDto.setSysName(sysName);
        whiteListCodePositionDto.setMd5Str(getMd5Str(value, sysName, className));
        whiteListCodePositionDtoLists.add(whiteListCodePositionDto);
    }


    public static String getMd5Str(String value, String sysName, String className) {
        return MD5.md5(value + sysName + className);
    }
}
