package cn.com.duiba.developer.center.api.domain.dto;

import cn.com.duiba.developer.center.api.domain.enums.PageEnum;
import static cn.com.duiba.developer.center.api.domain.enums.PageEnum.*;
import com.google.common.collect.ImmutableSet;

import java.io.Serializable;

/**
 * Created by liuyao on 2017/3/10.
 */
public class AerosolLinkDto implements Serializable {
    /**
     * 浮标支持的目的页
     */
    public static final ImmutableSet<PageEnum> DEST_SET = ImmutableSet.of(
         MAIN_MEET,SUB_PAGE,HOME,HD_TOOL,SECKILL_SUBJECT,QUESTION_ANSWER,QUIZZ,GAME,GUESS,ROB,LITTLE_GAME,CREDITS_GAME,CUSTOM
    );
    /**
     * 浮标支持的来源页
     */
    public static final ImmutableSet<PageEnum> SOURCE_SET = ImmutableSet.of(
         ALL,MAIN_MEET,SUB_PAGE,HOME,HD_TOOL,SECKILL_SUBJECT,QUESTION_ANSWER,QUIZZ,GAME,GUESS,ROB,LITTLE_GAME,CREDITS_GAME
    );

    private static final long serialVersionUID = -2371384837553364382L;

    private PageEnum destination;
    private String idLink;
    private PageEnum sourcePage;

    public PageEnum getDestination() {
        return destination;
    }

    public void setDestination(PageEnum destination) {
        this.destination = destination;
    }

    public String getIdLink() {
        return idLink;
    }

    public void setIdLink(String idLink) {
        this.idLink = idLink;
    }

    public PageEnum getSourcePage() {
        return sourcePage;
    }

    public void setSourcePage(PageEnum sourcePage) {
        this.sourcePage = sourcePage;
    }
}
