/**
 * Project Name:developer-center-api
 * File Name:BaseDto.java
 * Package Name:cn.com.duiba.developer.center.api.domain.dto
 * Date:2016年8月10日下午8:21:42
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.developer.center.api.domain.dto;

import java.io.Serializable;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;


/**
 * ClassName:BaseDto <br/>
 * DTO基类
 * Date:     2016年8月10日 下午8:21:42 <br/>
 * @author   zhanglihui
 * @since    JDK 1.6
 * @see 	 
 */
public class BaseDto implements Serializable {

    private static final long serialVersionUID = 500009963089192094L;
    
    /**
     * 
     * 重写toString()方法，日志打印时输出对象所有属性值，以便于排查问题
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /** 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    /** 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this, false);
    }
}

