package cn.com.duiba.developer.center.api.domain.dto;

import java.util.Date;

import cn.com.duiba.developer.center.api.domain.BaseDO;

/**
 * Created by liuyao on 16/7/18.
 */
public class RemainingMoneyDto extends BaseDO {
    private static final long serialVersionUID = -4287023933677070801L;
    private Long id;
    private Long developerId;
    private Integer money;
    private Long version;
    private String sign;

    private Date gmtCreate;
    private Date gmtModified;

    //业务主体，1:兑吧，2:兑啊，3:兑捷
    private Integer subject;
    //次序，用于追溯上一个业务主体
    private Integer sort;

    /**
     * 无参构造函数
     */
    public RemainingMoneyDto() {
        toBeUpdate = false;
        toBeInsert = false;
    }

    /**
     * 更新构造函数
     * @param id 实体Id
     */
    public RemainingMoneyDto(Long id) {
        this.id = id;
        this.gmtModified = new Date();
        toBeUpdate = true;
    }

    /**
     * 插入构造函数
     * @param init4insert
     */
    public RemainingMoneyDto(boolean init4insert) {
        if (init4insert) {
            toBeInsert = true;
            gmtCreate = new Date();
            gmtModified = gmtCreate;
        }
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getDeveloperId() {
        return developerId;
    }

    public void setDeveloperId(Long developerId) {
        this.developerId = developerId;
    }

    public Integer getMoney() {
        return money;
    }

    public void setMoney(Integer money) {
        this.money = money;
    }

    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getSubject() {
        return subject;
    }

    public void setSubject(Integer subject) {
        this.subject = subject;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }
}
