package cn.com.duiba.developer.center.api.domain.dto.innerpage;

import java.io.Serializable;
import java.util.Date;

/**
* 积分商城内页皮肤表
*/
public class InnerPageCustomSkinDto implements Serializable {

    private static final long serialVersionUID = 7392793761612686994L;
    /**
    * 皮肤id
    */
    private Long id;

    /**
    * 视图显示路径
    */
    private String path;

    /**
    * 皮肤名称
    */
    private String skinName;

    /**
    * 皮肤内容
    */
    private String content;

    /**
     * 多场景key id
     */
    private String groupKey;

    /**
    * 删除标识 （0：未删除，1：删除）默认为0
    */
    private Integer deleted;

    /**
    * 状态（0：关闭，1：开启），默认为0
     * 上预发数据库字段status被打回，改成state
    */
    private Integer status;

    /**
     * 环境状态（0：非线上，1：线上），默认为0
     */
    private Integer envType;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
    * 皮肤支持多个appId以逗号隔开，空表示针对所有app
    */
    private String appIdStr;

    /**
    * 操作人
    */
    private String operator;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return path;
    }

    public void setSkinName(String skinName) {
        this.skinName = skinName;
    }

    public String getSkinName() {
        return skinName;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return content;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return status;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setAppIdStr(String appIdStr) {
        this.appIdStr = appIdStr;
    }

    public String getAppIdStr() {
        return appIdStr;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getOperator() {
        return operator;
    }

    public Integer getEnvType() {
        return envType;
    }

    public void setEnvType(Integer envType) {
        this.envType = envType;
    }

    public String getGroupKey() {
        return groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }
}

